<?php
include_once '../../login/databases/Pesquisar.php';
$Pesquisar = new Pesquisar();
?>


<!DOCTYPE html>
<html lang="pt-br">
<head>
     
    <meta  charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">

    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ficha Cadastral</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-GLhlTQ8iRABdZLl6O3oVMWSktQOp6b7In1Zl3/Jr59b6EGGoI1aFkw7cmDA6j6gD" crossorigin="anonymous">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.4/jquery.min.js" integrity="sha512-pumBsjNRGGqkPzKHndZMaAG+bir374sORyzM3uulLV14lN5LyykqNk8eEeUlUkB3U0M4FApyaHraT65ihJhDpQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js" integrity="sha384-w76AqPfDkMBDXo30jS1Sgez6pr3x5MlQ1ZAGC+nuZB+EYdgRZgiwxhTBTkF7CXvN" crossorigin="anonymous"></script>

    <script src="../src/utils/htmlidacao.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.3.0/css/all.min.css" integrity="sha512-SzlrxWUlpfuzQ+pcUCosxcglQRNAq/DZjVsC0lE40xsADsfeQoEypE+enwcOiGjk/bSuGGKHEyjSoQ1zVisanQ==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.3.0/css/all.min.css" integrity="sha512-SzlrxWUlpfuzQ+pcUCosxcglQRNAq/DZjVsC0lE40xsADsfeQoEypE+enwcOiGjk/bSuGGKHEyjSoQ1zVisanQ==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <style type="text/css"></style>
    <style>
        .row{
            margin: 0;
        }
        .space{
            padding: 1%;
        }
        .form-floating>.form-control:not(:placeholder-shown)~label , .form-floating>.form-select~label{
            opacity: 1;
            color: rgba(0, 0, 0, 0.849);
            font-weight: 500;
        }
        label.subtitulo{
            opacity: 1;
            color: rgba(0, 0, 0, 0.849);
            font-weight: 500;
            padding: auto;
            
        }
        .underline{
            border-bottom: 1px solid rgba(95, 94, 94, 0.5);
            padding: 0.3%;
            margin-bottom: 2%;
        }
        .card{
            margin: 2%;
            box-shadow: 1px 1px 2px rgba(43, 100, 175, 0.753);
        }
        .line{
            display: flow-root;
            align-items: center;
            justify-content: center;
            margin-top: 100px;
            border-right: solid 6px rgb(49, 88, 218);
        }
        .line > a > div{
            margin-left: 55%;
            margin-top: -12;
        }

        .trashed{
            display: flex;
            align-items: center;
            justify-content: center; 
        }
        .title{
            width: 100%;
            padding: 1%;
            font-weight: 500;
            text-align: center;
            font-size: 18px;
        }
        div[type="text"]{
            text-transform: uppercase;
        }

        .text-link{
            text-decoration: none;
            color: white;
            opacity: 0.5;
        }
        .border_b{
            text-align: center;
        }
        
        .border_b:hover{
            border-bottom: 1px solid white;
        }
        .text-link:hover{
            opacity: 1;
        }
        .form{
            margin-top: 8%;
            width: 100%;
            padding: 0;
        }
        .orgao{
            margin-top: 0.5%;
        }
        .fs-fp{
            font-size: 12px;
        }

        .border-dep{
            margin: 1%;
            border: solid 0.7px rgba(0, 0, 0, 0.1);
            border-radius: 10px;
        }

        .border-dep:hover{
            background: rgba(0, 0, 0, 0.03);
        }
        @media (max-width: 1668px) {
            .text-link, .usuario-flex{
                font-size: 10px;
            }
            .orgao{
                font-size: 11px;
            }

            .fs-fp{
                font-size: 10px;
            }
            
            
        }
        @media (max-width: 1192px) {
            .text-link, .usuario-flex{
                font-size: 9px;
            }
            .orgao{
                font-size: 11px;
            }
            .fs-fp{
                font-size: 10px;
            }

        }
        @media (max-width: 1108px) {
            .text-link, .usuario-flex{
                font-size: 6px;
            }
            .orgao{
                font-size: 8px;
            }
            .fs-fp{
                font-size: 6px;
            }
        }
        
    </style>
</head>
<body>
<!-- <form action="Javascript:void(0)" id="FormPesquisa">
    <div class="row">

      <div class="col-md-3"></div>
      <div class="form-group col-md-2">
        <label for="recipient-name" class="col-form-label" style="margin-left:10px"><i class="fas fa-user"></i> Servidor:  <small id="aviso_"></small>
        </label>
        <input type="text" class="form-control" id="servidor" name="servidor" placeholder="Digite o nome / CPF do servidor ">

      </div>

      <div class="form-group col-md-2" style="padding-top: 0px;">
        <label for="recipient-name" class="col-form-label" ><i class="fas fa-landmark"></i> Poder Público:</label>
        <select class="custom-select w-100" name="poderpublico" style="height: 37px; border-radius: 5px;">
          <?php  if($_SESSION["tipo"] != 'funcionario'){?>
        <?php }; ?>
          <?php 
            // $Pesquisar->Push_PoderPublico_func($_SESSION['list_poderpublico']);
          ?>
        </select>
      </div>
      <div class="col-md-1">
        <button type="submit" class="btn btn-success" style="margin-top: 37px;height: 37px; width: auto;">
          <i class="fas fa-search"></i>
        </button>
      </div>
    </div>
  </form> -->

    <div id="lista">
        <table class="table">
          <thead>
            <tr>
              <th scope="col">#</th>
              <th scope="col">Nome</th>
              <th scope="col">CPF</th>
              <th scope="col">Poder Público</th>
              <th scope="col" colspan="2" style="text-align: center;">Ações</th>
          </tr>
      </thead>
      <tbody id="list_item">

      </tbody>
  </table>
</div>

<!-- Button trigger modal -->

<!-- Modal -->
<div class="modal fade" id="fichaCadastralModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="fichaCadastralModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-fullscreen">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="fichaCadastralModalLabel">Modal title</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
    </div>
    <div class="modal-body">
        <div>
            <div class="row" style="margin-left: 2%;">
                <div class="col-md-12 text-center">
                   <h1 id="prefeitura">
                   </h1>
               </div>
               <div class="col-md-12 text-center"><br></div>
               <div class="col-md-12 text-center">
                   <h1>
                    FICHA CADASTRAL
                    
                </h1>
            </div>
            <div class="col-md-12">
                <div class=" card space" id="div_dadospessoais">
                    
                    <div class="row">
                        <div class="col-md-12">
                            <label class="subtitulo" for="" class="title">DADOS PESSOAIS</label>
                            <hr>
                        </div>
                        <div class="col-md-12 space" >
                            <div class="row">
                                <div class="col-md-12">
                                    <label class="subtitulo" for="nome">
                                        NOME SERVIDOR:
                                    </label>
                                    <div id="nome"></div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-8 space">
                            <div class="row">
                                <div class="col-md-12">
                                    <label class="subtitulo" for="nome_social">
                                        NOME SOCIAL:
                                    </label>
                                    <div id="nome_social"></div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 space">
                            <div class="row">
                                <div class="col-md-12">
                                    <label class="subtitulo" for="matricula">
                                        MATRÍCULA:
                                    </label>
                                    <div id="matricula"></div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 space">
                            <div class="row">
                                <div class="col-md-12">
                                    <label class="subtitulo" for="cpf">
                                        CPF:
                                    </label>
                                    <div id="cpf"></div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 space">
                            <div class="row">
                                <div class="col-md-12">
                                    <label class="subtitulo" for="pispasep">
                                        NIS(PIS/PASEP/NIT):
                                    </label>
                                    <div id="pispasep"></div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 space">
                            <div class="row">
                                <div class="col-md-12">
                                    <label class="subtitulo" for="dtnacimento">
                                        DATA DE NASCIMENTO:
                                    </label>
                                    <div id="dtnacimento"></div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 space">
                            <div class="row">
                                <div class="col-md-12">
                                    <label class="subtitulo" for=""> ESTADO CIVIL:</label>
                                </div>
                                <div id="estadocivil"></div>                             
                            </div>
                        </div>
                        <div class="col-md-6 space">
                            <div class="row">
                                <div class="col-md-12">
                                    <label class="subtitulo" for=""> GÊNERO:</label>
                                </div>
                                <div id="genero"></div>
                            </div>
                        </div>
                        <div class="col-md-6 space">
                            <div class="row">
                                <div class="col-md-12">
                                    <label class="subtitulo" for="nacionalidade">
                                        NACIONALIDADE:
                                    </label>
                                    <div id="nacionalidade"></div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 space">
                            <div class="row">
                                <div class="col-md-12">
                                    <label class="subtitulo" for="ufnaruralidade">
                                        UF:
                                    </label>
                                    <div id="ufnaruralidade"></div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 space">
                            <div class="row">
                                <div class="col-md-12">
                                    <label class="subtitulo" for="naturalidade">
                                        NATURALIDADE:
                                    </label>
                                    <div id="naturalidade"></div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-12 space">
                            <div class="row">
                                <div class="col-md-12">
                                    <label class="subtitulo" for="email">
                                        EMAIL:
                                    </label>
                                    <div id="email"></div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12 space">
                            
                            <div class="row">
                                <div class="col-md-12">
                                    <label class="subtitulo" for="racaCor">
                                        RAÇA/COR:
                                    </label>
                                    <div id="racaCor"></div>
                                </div>  
                            </div>
                        </div>
                        
                        <div class="col-md-12 row space">

                            <div class="col-md-8">
                                <div class="">
                                    <label class="subtitulo" for="nome_mae">
                                        NOME MÃE:
                                    </label>
                                    <div id="nome_mae"></div>
                                </div>
                            </div>                
                            <div class="col-md-4">
                                <div class="">
                                    <label class="subtitulo" for="cpf_mae">
                                        CPF MÃE:
                                    </label>
                                    <div id="cpf_mae"></div>
                                </div>
                            </div>

                        </div>
                        
                        <div class="col-md-12 row space">

                            <div class="col-md-8">
                                <div class="">
                                    <label class="subtitulo" for="nome_pai">
                                        NOME PAI:
                                    </label>
                                    <div id="nome_pai"></div>
                                </div>
                            </div>                
                            <div class="col-md-4">
                                <div class="">
                                    <label class="subtitulo" for="cpf_pai">
                                        CPF PAI:
                                    </label>
                                    <div id="cpf_pai"></div>
                                </div>
                            </div>

                        </div>

                    </div>
                </div>
                <div class=" card space" id="div_dadosdocumentos">
                    <div class="row">
                        <div class="col-md-12 space">
                            <div class="row">
                                <div class="col-md-12">
                                    <label class="subtitulo" for="" class="title">OUTROS DOCUMENTOS</label>
                                    <div></div>
                                    <hr>
                                </div>
                                <div class="col-md-12"><label class="subtitulo" for="">REGISTRO GERAL</label></div>
                                <div></div>
                                <div class="col-md-3 space">
                                    <div class="">
                                        <label class="subtitulo" for="rg">
                                            RG:
                                        </label>
                                        <div id="rg"></div>
                                    </div>
                                </div>
                                <div class="col-md-5 space">
                                    <div class="">
                                        <label class="subtitulo" for="orgaoexp">
                                            ÓRGÃO EXPEDIDOR:
                                        </label>
                                        <div id="orgaoexp"></div>
                                    </div>
                                </div>
                                <div class="col-md-2 space">
                                    <div class="">
                                        <label class="subtitulo" for="ufexpedicao">
                                            UF:
                                        </label>
                                        <div id="ufexpedicao"></div>
                                    </div>
                                </div>
                                <div class="col-md-2 space">
                                    <div class="">
                                        <label class="subtitulo" for="dtexpedicao">
                                            EXPEDIÇÃO:
                                        </label>
                                        <div id="dtexpedicao"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12 space">
                            
                            <div class="row">
                                <div class="col-md-12"> <label class="subtitulo" for="">RESERVISTA</label></div>
                                <div></div>
                                <div class="col-md space">
                                    <div class="">
                                        <label class="subtitulo" for="num_reservista">
                                            N°:
                                        </label>
                                        <div id="num_reservista"></div>
                                    </div>
                                </div>
                                <div class="col-md space">
                                    <div class="">
                                        <label class="subtitulo" for="dtexpreservista">
                                            EXPEDIÇÃO:
                                        </label>
                                        <div id="dtexpreservista"></div>
                                    </div>
                                </div>
                                <div class="col-md space">
                                    <div class="col-md">
                                        <div class="">
                                            <label class="subtitulo" for="serie_reservista">
                                                SÉRIE:
                                            </label>
                                            <div id="serie_reservista"></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md space">
                                    <div class="">
                                        <label class="subtitulo" for="ra_reservista">
                                            RA:
                                        </label>
                                        <div id="ra_reservista"></div>
                                    </div>
                                </div>

                            </div>
                        </div>
                        <div class="col-md-12">
                            
                            <div class="row">
                                <div class="col-md-12"><label class="subtitulo" for="">TÍTULO DE ELEITOR</label></div>
                                <div></div>
                                <div class="col-md space">
                                    <div class="">
                                        <label class="subtitulo" for="num_teleitor">
                                            N°:
                                        </label>
                                        <div id="num_teleitor"></div>
                                    </div>
                                </div>
                                <div class="col-md space">
                                    <div class="col-md">
                                        <div class="">
                                            <label class="subtitulo" for="zona_teleitor">
                                                ZONA:
                                            </label>
                                            <div id="zona_teleitor"></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md space">
                                    <div class="">
                                        <label class="subtitulo" for="sessao_teleitor">
                                            SEÇÃO:
                                        </label>
                                        <div id="sessao_teleitor"></div>
                                    </div>
                                </div>
                                <div class="col-md space">
                                    <div class="">
                                        <label class="subtitulo" for="dtemissaoTitulo">
                                            EMISSÃO:
                                        </label>
                                        <div id="dtemissaoTitulo"></div>
                                    </div>
                                </div>
                                <div class="col-md space">
                                    <div class="">
                                        <label class="subtitulo" for="uf_teleitor">
                                            UF:
                                        </label>
                                        <div id="uf_teleitor"></div>
                                    </div>
                                </div>

                            </div>
                        </div>
                        <div class="col-md-12">
                            
                            <div class="row">
                                <div class="col-md-12"><label class="subtitulo" for="">CNH</label></div>
                                <hr>
                                <div class="col-md space">
                                    <div class="">
                                        <label class="subtitulo" for="ncnh">
                                            N° HABILITAÇÃO:
                                        </label>
                                        <div id="ncnh"></div>
                                    </div>
                                </div>
                                <div class="col-md space">
                                    <div class="">
                                        <label class="subtitulo" for="catcnh">
                                            CATEGORIA:
                                        </label>
                                        <div id="catcnh"></div>
                                    </div>
                                </div>
                                <div class="col-md space">
                                    <div class="">
                                        <label class="subtitulo" for="validadecnh">
                                            VALIDADE:
                                        </label>
                                        <div id="validadecnh"></div>
                                    </div>
                                </div>
                                <div class="col-md space">
                                    <div class="">
                                        <label class="subtitulo" for="pcnh">
                                            1° HAB:
                                        </label>
                                        <div id="pcnh"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            
                            <div class="row">
                                <div class="col-md-12"><label class="subtitulo" for="">CTPS</label></div>
                                <div></div>
                                <div class="col-md space">
                                    <div class="">
                                        <label class="subtitulo" for="nctps">
                                            N°: 
                                        </label>
                                        <div id="nctps"></div>
                                    </div>
                                </div>
                                <div class="col-md space">
                                    <div class="">
                                        <label class="subtitulo" for="serie_ctps">
                                            SÉRIE: 
                                        </label>
                                        <div id="serie_ctps"></div>
                                    </div>
                                </div>
                                <div class="col-md space">
                                    <div class="">
                                        <label class="subtitulo" for="uf_ctps">
                                            UF: 
                                        </label>
                                        <div id="uf_ctps"></div>
                                    </div>
                                </div>
                                <div class="col-md space">
                                    <div class="">
                                        <label class="subtitulo" for="dtemissaoctps">
                                            EMISSÃO: 
                                        </label>
                                        <div id="dtemissaoctps"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class=" card space" id="div_dadosbancarios">
                    <div class="row">
                        <div class="col-md-12">
                            <label class="subtitulo" for="" class="title">DADOS BANCÁRIOS</label>
                            <hr>
                        </div>
                        <div class="col-md-12 row">
                            <div class="col-md-2 space">
                                <div class="">
                                    <label class="subtitulo" for="codbanco">
                                        COD. BANCO:
                                    </label>
                                    <div id="codbanco"></div>
                                </div>
                            </div>
                            <div class="col-md-6 space">
                                <div class="">
                                    <label class="subtitulo" for="banco">
                                        BANCO:
                                    </label>
                                    <div id="banco"></div>
                                </div>
                            </div>
                            <div class="col-md-4 space">
                                <div class="">
                                    <label class="subtitulo" for="tipodeconta">
                                        TIPO DE CONTA:
                                    </label>
                                    <div id="tipodeconta"></div>
                                </div>
                            </div>
                            <div class="col-md-4 space">
                                <div class="">
                                    <label class="subtitulo" for="agenciabanco">
                                        AGÊNCIA:
                                    </label>
                                    <div id="agenciabanco"></div>
                                </div>
                            </div>
                            <div class="col-md-2 space">
                                <div class="">
                                    <label class="subtitulo" for="digagenciabanco">
                                        DIG:
                                    </label>
                                    <div id="digagenciabanco"></div>
                                </div>
                            </div>
                            <div class="col-md-4 space">
                                <div class="">
                                    <label class="subtitulo" for="contabanco">
                                        CONTA:
                                    </label>
                                    <div id="contabanco"></div>
                                </div>
                            </div>
                            <div class="col-md-2 space">
                                <div class="">
                                    <label class="subtitulo" for="digcontabanco">
                                        DIG:
                                    </label>
                                    <div id="digcontabanco"></div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
                <div class=" card space" id="div_dadosendereco">
                    <div class="row">
                        <div class="col-md-12">
                            <label class="subtitulo" for="" class="title">ENDEREÇO</label>
                            <hr>
                        </div>

                        <div class="col-md-2 space">
                            <div class="">
                                <label class="subtitulo" for="cep">
                                    CEP:
                                </label>
                                <div id="cep"></div>
                            </div>
                        </div>

                        <div class="col-md-10 space">
                            <div class="">
                                <label class="subtitulo" for="endereco">
                                    ENDEREÇO:
                                </label>
                                <div id="endereco"></div>
                            </div>
                        </div>
                        <div class="col-md-2 space">
                            <div class="">
                                <label class="subtitulo" for="numeroendereco">
                                    N°:
                                </label>
                                <div id="numeroendereco"></div>
                            </div>
                        </div>
                        <div class="col-md-2 space">
                            <div class="">
                                <label class="subtitulo" for="quadra">
                                    QDA:
                                </label>
                                <div id="quadra"></div>
                            </div>
                        </div>
                        <div class="col-md-4 space">
                            <div class=" space">
                                <label class="subtitulo" for="lote">
                                    LOTE:
                                </label>
                                <div id="lote"></div>
                            </div>
                        </div>
                        <div class="col-md-4 space">
                            <div class="">
                                <label class="subtitulo" for="bairro">
                                    BAIRRO:
                                </label>
                                <div id="bairro"></div>
                            </div>
                        </div>
                        <div class="col-md-3 space">
                            <div class="">
                                <label class="subtitulo" for="ufendereco">
                                    UF:
                                </label>
                                <div id="ufendereco"></div>
                            </div>
                        </div>
                        <div class="col-md-3 space">
                            <div class="">
                                <label class="subtitulo" for="cidadeendereco">
                                    CIDADE:
                                </label>
                                <div id="cidadeendereco"></div>
                            </div>
                        </div>
                        <div class="col-md-3 space">                
                            <div class="">
                                <label class="subtitulo" for="tel_fixo">
                                    TELEFONE FIXO:
                                </label>
                                <div id="tel_fixo"></div>
                            </div></div>
                            <div class="col-md-3 space">
                                <div class="">
                                    <label class="subtitulo" for="tel_cel">
                                        CELULAR:
                                    </label>
                                    <div id="tel_cel"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class=" card space" id="div_dadosfuncionais">
                        <div class="row">
                            <div class="col-md-12">
                                <label class="subtitulo" for="" class="title">DADOS FUNCIONAIS</label>
                                <div></div>
                                <hr>
                            </div>
                            <div class="col-md-12 space">
                                <div>
                                    <label class="subtitulo" for="">VÍNCULO:</label>
                                </div>
                                <div id="vinculo"></div>
                            </div>
                            <div class="col-md-6 space">
                                <div class="">
                                    <label class="subtitulo" for="secretaria">
                                        SECRETARIA:
                                    </label>
                                    <div id="secretaria"></div>
                                </div>
                            </div>
                            <div class="col-md-6 space">
                                <div class="">
                                    <label class="subtitulo" for="dtadmissao">
                                        ADMISSÃO:
                                    </label>
                                    <div id="dtadmissao"></div>
                                </div>
                            </div>
                            <div class="col-md-6 space">
                                <div class="">
                                    <label class="subtitulo" for="cargo">
                                        CARGO:
                                    </label>
                                    <div id="cargo"></div>
                                </div>
                            </div>
                            <div class="col-md-6 space">
                                <div class="">
                                    <label class="subtitulo" for="salbase">
                                        SALÁRIO BASE (R$):
                                    </label>
                                    <div id="salbase"></div>
                                </div>
                            </div>
                            <div class="col-md-6 space">
                                <div class="">
                                    <label class="subtitulo" for="escola">
                                        ESCOLA (SIOPE):
                                    </label>
                                    <div id="escola"></div>
                                </div>
                            </div>
                            <div class="col-md-6 space">
                                <div class="">
                                    <label class="subtitulo" for="segatu">
                                        SEGMENTO ATUAÇÃO (SIOPE):
                                    </label>
                                    <div id="segatu"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class=" card space" id="div_dependentes">
                        <div class="row">
                            <div class="col-md-12">
                                <label class="subtitulo" for="" class="title">DEPENDENTES</label>
                                <div></div>
                                <hr>
                            </div>
                            <div class="col-md-12" id="dependentes">

                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>        
    </div>
    <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
        <a href="" id="btn_imprimir" class="btn btn-primary">Imprimir <i class="fa-solid fa-print"></i></a>
    </div>
</div>
</div>
</div>



<script type="text/javascript">

    $.ajax({
        type: "GET",
        url: '../Api_/v1/listar.php',
        dataType:'json',
        success: function(data) {
            Array.prototype.forEach.call(data, function(key){
                factory_list(key.nome,key.cpf,key.poderpublico,key.id);
            });

            $('.btn_modal').on('click', function(event){
                loadDataModal(event.delegateTarget.data);
            })
        }
    })

function loadDataModal(id){

    $.ajax({
        type: "GET",
        url: '../Api_/v1/fichacadastral.php?id='+id,
        dataType:'json',
        success: function(data) {

            switch (data.estadocivil) {
            case "1":$('#estadocivil').html('Solteiro(a)'); break;
            case "2":$('#estadocivil').html('Casado(a)'); break;
            case "3":$('#estadocivil').html('Divorciado(a)'); break;
            case "4":$('#estadocivil').html('Viúvo(a)'); break;
            case "5":$('#estadocivil').html('União Estável'); break;
            case "6":$('#estadocivil').html('Outros'); break;
            }

            switch (data.genero) {
            case "1":$('#genero').html('Masculino');break;
            case "2":$('#genero').html('Casado(a)');break;
            }
            
            switch (data.nacionalidade) {
            case "10": 
                $('#nacionalidade').html('Brasileiro'); break;
            case "20": 
                $('#nacionalidade').html('Naturalizado Brasileiro'); break;
            case "21": 
                $('#nacionalidade').html('Argentino'); break;
            case "22": 
                $('#nacionalidade').html('Boliviano'); break;
            case "23": 
                $('#nacionalidade').html('Chileno'); break;
            case "24": 
                $('#nacionalidade').html('Paraguaio'); break;
            case "25": 
                $('#nacionalidade').html('Uruguaio'); break;
            case "30": 
                $('#nacionalidade').html('Alemão'); break;
            case "31": 
                $('#nacionalidade').html('Belga'); break;
            case "32": 
                $('#nacionalidade').html('Britânico'); break;
            case "34": 
                $('#nacionalidade').html('Canadense'); break;
            case "35": 
                $('#nacionalidade').html('Espanhol'); break;
            case "36": 
                $('#nacionalidade').html('Norte-Americano (EUA)'); break;
            case "37": 
                $('#nacionalidade').html('Francês'); break;
            case "38": 
                $('#nacionalidade').html('Suíço'); break;
            case "39": 
                $('#nacionalidade').html('Italiano'); break;
            case "41": 
                $('#nacionalidade').html('Japonês'); break;
            case "42": 
                $('#nacionalidade').html('Chinês'); break;
            case "43": 
                $('#nacionalidade').html('Coreano'); break;
            case "45": 
                $('#nacionalidade').html('Português'); break;
            case "48": 
                $('#nacionalidade').html('Outros latinos-americanos'); break;
            case "49": 
                $('#nacionalidade').html('Outros asiáticos'); break;
            case "50": 
                $('#nacionalidade').html('Outros'); break;
            }

            switch (data.racaCor) {
            case "1" : $("#racaCor").html("Indígena"); break;
            case "2" : $("#racaCor").html("Branca"); break;
            case "3" : $("#racaCor").html("Negra/Preta"); break;
            case "4" : $("#racaCor").html("Amarela"); break;
            case "5" : $("#racaCor").html("Parda"); break;
            case "6" : $("#racaCor").html("Não informado"); break;
            }

            switch (data.orgaoexp) {
            case "0" :  $("#orgaoexp").html("SSP - SECRETARIA DE SEGURANÇA PÚBLICA"); break;
            case "1" :  $("#orgaoexp").html("PM - Polícia Militar"); break;
            case "2" :  $("#orgaoexp").html("PC - Policia Civil"); break;
            case "3" :  $("#orgaoexp").html("CNT - Carteira Nacional de Habilitação"); break;
            case "4" :  $("#orgaoexp").html("DIC - Diretoria de Identificação Civil"); break;
            case "5" :  $("#orgaoexp").html("CTPS - Carteira de Trabaho e Previdência Social"); break;
            case "6" :  $("#orgaoexp").html("FGTS - Fundo de Garantia do Tempo de Serviço"); break;
            case "7" :  $("#orgaoexp").html("IFP - Instituto Félix Pacheco"); break;
            case "8" :  $("#orgaoexp").html("IPF - Instituto Pereira Faustino"); break;
            case "9" :  $("#orgaoexp").html("IML - Instituto Médico-Legal"); break;
            case "10" :  $("#orgaoexp").html("MTE - Ministério do Trabalho e Emprego"); break;
            case "11" :  $("#orgaoexp").html("MMA - Ministério da Marinha"); break;
            case "12" :  $("#orgaoexp").html("MAE - Ministério da Aeronáutica"); break;
            case "13" :  $("#orgaoexp").html("MEX - Ministério do Exército"); break;
            case "14" :  $("#orgaoexp").html("POF - Polícia Federal"); break;
            case "15" :  $("#orgaoexp").html("POM - Polícia Militar"); break;
            case "16" :  $("#orgaoexp").html("SES - Carteira de Estrangeiro"); break;
            case "17" :  $("#orgaoexp").html("SJS - Secretaria da Justiça e Segurança"); break;
            case "18" :  $("#orgaoexp").html("SJTS - Secretaria da Justiça do Trabalho e Segurança"); break;
            case "19" :  $("#orgaoexp").html("ZZZ - Outros (inclusive exterior)"); break;
            }

            switch (data.tipodeconta) {
            case "1": $('#tipodeconta').html('Conta Corrente'); break;
            case "3":$('#tipodeconta').html('Conta Salário'); break;
            }

            switch (data.vinculo) {
            case "1": $("#vinculo").html("EFETIVO"); break;
            case "2": $("#vinculo").html("COMISSIONADO"); break;
            case "4": $("#vinculo").html("CELETISTA"); break;
            case "6": $("#vinculo").html("ELETIVO"); break;
            case "8": $("#vinculo").html("CONTRATADO"); break;
            }
            $("#prefeitura").html(data.poderpublico);
            $('#nome').html(data.nome);
            $('#nome_social').html(data.nome_social);
            $('#matricula').html(data.matricula);
            $('#cpf').html(data.cpf);
            $('#pispasep').html(data.pispasep);
            $('#dtnacimento').html(data.dtnacimento);
            $('#ufnaruralidade').html(data.ufnaruralidade);
            $('#naturalidade').html(data.naturalidade);
            $('#email').html(data.email);
            $('#nome_pai').html(data.nome_pai);
            $('#cpf_pai').html(data.cpf_pai);
            $('#nome_mae').html(data.nome_mae);
            $('#cpf_mae').html(data.cpf_mae);
            $('#rg').html(data.rg);
            $('#ufexpedicao').html(data.ufexpedicao);
            $('#dtexpedicao').html(data.dtexpedicao);
            $('#num_reservista').html(data.num_reservista);
            $('#dtexpreservista').html(data.dtexpreservista);
            $('#serie_reservista').html(data.serie_reservista);
            $('#ra_reservista').html(data.ra_reservista);
            $('#num_teleitor').html(data.num_teleitor);
            $('#zona_teleitor').html(data.zona_teleitor);
            $('#sessao_teleitor').html(data.sessao_teleitor);
            $('#dtemissaoTitulo').html(data.dtemissaoTitulo);
            $('#uf_teleitor').html(data.uf_teleitor);
            $('#ncnh').html(data.ncnh);
            $('#catcnh').html(data.catcnh);
            $('#validadecnh').html(data.validadecnh);
            $('#pcnh').html(data.pcnh);
            $('#nctps').html(data.nctps);
            $('#serie_ctps').html(data.serie_ctps);
            $('#uf_ctps').html(data.uf_ctps);
            $('#dtemissaoctps').html(data.dtemissaoctps);
            $('#codbanco').html(data.codbanco);
            $('#banco').html(data.banco);
            $('#agenciabanco').html(data.agenciabanco);
            $('#digagenciabanco').html(data.digagenciabanco);
            $('#contabanco').html(data.contabanco);
            $('#digcontabanco').html(data.digcontabanco);
            $('#cep').html(data.cep);
            $('#endereco').html(data.endereco);
            $('#numeroendereco').html(data.numeroendereco);
            $('#quadra').html(data.quadra);
            $('#lote').html(data.lote);
            $('#bairro').html(data.bairro);
            $('#ufendereco').html(data.ufendereco);
            $('#cidadeendereco').html(data.cidadeendereco);
            $('#tel_fixo').html(data.tel_fixo);
            $('#tel_cel').html(data.tel_cel);
            $('#secretaria').html(data.secretaria);
            $('#dtadmissao').html(data.dtadmissao);
            $('#cargo').html(data.cargo);
            $('#salbase').html(data.salbase);
            $('#escola').html(data.escola);
            $('#segatu').html(data.segatu);
            $('#btn_imprimir').attr('href', 'print.php?id='+data.id);

            cpfDependentes = JSON.parse(data.cpfDependentes);
            dtNascimentoDependente = JSON.parse(data.dtNascimentoDependente);
            emissaoRegDependentes = JSON.parse(data.emissaoRegDependentes);
            nomeDependente = JSON.parse(data.nomeDependente);
            rgDependentes = JSON.parse(data.rgDependentes);

            for ($i = 0; $i < cpfDependentes.length; $i++){
                if(cpfDependentes[$i] == null || cpfDependentes[$i] != '' || cpfDependentes[$i].length != 0) {
                    factory_dependentest(nomeDependente[$i],dtNascimentoDependente[$i],cpfDependentes[$i], rgDependentes[$i], emissaoRegDependentes[$i]);
                }
            }
        }
    });
}


function factory_list(nome,cpf,pp,id){
    
   let tr = document.createElement('tr');
   let td_id = document.createElement('td');
   let td_nome = document.createElement('td');
   let td_cpf = document.createElement('td');
   let td_pp = document.createElement('td');
   let td_modal = document.createElement('td');
   td_modal.setAttribute('style','text-align:center;');
   let td_print   = document.createElement('td');
   td_print.setAttribute('style','text-align:center;');
   
   let btn_print = document.createElement('a');
   let btn_modal = document.createElement('button');

   btn_print.classList = 'btn btn-primary';
   btn_print.setAttribute('href', 'print.php?id='+id);
   btn_print.innerHTML =  '<i class="fa-solid fa-print"></i>';
   td_print.appendChild(btn_print);

   btn_modal.type = 'button';
   btn_modal.classList = 'btn btn-primary btn_modal';
   btn_modal.data = id;
   btn_modal.setAttribute('rel',id);
   btn_modal.setAttribute('data-bs-toggle','modal');
   btn_modal.setAttribute('data-bs-target','#fichaCadastralModal');
   btn_modal.innerHTML =  '<i class="fa-solid fa-eye"></i>';
   td_modal.appendChild(btn_modal); 




   td_id.innerHTML = id;
   td_nome.innerHTML = nome;
   td_cpf.innerHTML = cpf;
   td_pp.innerHTML = pp;

   tr.appendChild(td_id);
   tr.appendChild(td_nome);
   tr.appendChild(td_cpf);
   tr.appendChild(td_pp);
   tr.appendChild(td_modal);
   tr.appendChild(td_print);
   
   
// <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#fichaCadastralModal">

   document.getElementById('list_item').appendChild(tr);



}

function factory_dependentest(nomeDependente,dtNascimentoDependente,cpfDependentes,rgDependentes,emissaoRegDependentes){

    let row = document.createElement('div');
    row.classList = 'row border-dep';

    let div_data = document.createElement('div');
    div_data.classList = 'col-md-11 row space';


                // NOME DEPENDENTES
    let deleted = document.createElement('div');
    deleted.classList = 'col-md-12 space';

    
    let div_col = document.createElement('div');
    div_col.classList = 'col-md-8 space';
    
    let div_floating = document.createElement('div');

    let div_nome = document.createElement('div');
    div_nome.innerHTML = nomeDependente;


    let label_nome = document.createElement('label');
    label_nome.classList = 'subtitulo';
    label_nome.innerText = 'NOME:';
    

                // DATA DE NASCIMENTO
    let div_col_dt = document.createElement('div');
    div_col_dt.classList = 'col-md-4 space';
    
    let div_floating_dt = document.createElement('div');

    let div_dt = document.createElement('div');
                    div_dt.innerHTML = dtNascimentoDependente.replace(/(\d*)-(\d*)-(\d*).*/, '$3/$2/$1');
    ;

    let label_dt = document.createElement('label');
    label_dt.classList = 'subtitulo';
    label_dt.innerText = 'NASCIMENTO:';
    

                //CPF
    let div_col_cpf = document.createElement('div');
    div_col_cpf.classList = 'col-md-4 space';
    
    let div_floating_cpf = document.createElement('div');

    let div_cpf = document.createElement('div');
    div_cpf.innerHTML = cpfDependentes;
    

    let label_cpf = document.createElement('label');
    label_cpf.classList = 'subtitulo';
    label_cpf.innerText = 'CPF:';
    
                //RG
    let div_col_rg = document.createElement('div');
    div_col_rg.classList = 'col-md-4 space';
    
    let div_floating_rg = document.createElement('div');

    let div_rg = document.createElement('div');
    div_rg.innerHTML = rgDependentes;

    let label_rg = document.createElement('label');
    label_rg.classList = 'subtitulo';
    label_rg.innerText = 'RG:';
    

                // DATA DE EMISSAO RG
    let div_col_dt_emi_rg = document.createElement('div');
    div_col_dt_emi_rg.classList = 'col-md-4 space';
    
    let div_floating_dt_emi_rg = document.createElement('div');

    let div_dt_emi_rg = document.createElement('div');
                    div_dt_emi_rg.innerHTML = emissaoRegDependentes.replace(/(\d*)-(\d*)-(\d*).*/, '$3/$2/$1');

    let label_dt_emi_rg = document.createElement('label');
    label_dt_emi_rg.classList = 'subtitulo';
    label_dt_emi_rg.innerText = 'EMISSÃO:';
    


    div_data.appendChild(div_col);
    div_col.appendChild(div_floating);
    div_floating.appendChild(label_nome);
    div_floating.appendChild(div_nome);

    div_data.appendChild(div_col_dt);
    div_col_dt.appendChild(div_floating_dt);
    div_floating_dt.appendChild(label_dt);
    div_floating_dt.appendChild(div_dt);

    div_data.appendChild(div_col_cpf);
    div_col_cpf.appendChild(div_floating_cpf);
    
    div_floating_cpf.appendChild(label_cpf);
    div_floating_cpf.appendChild(div_cpf);

    div_data.appendChild(div_col_rg);
    div_col_rg.appendChild(div_floating_rg);
    div_floating_rg.appendChild(label_rg);
    div_floating_rg.appendChild(div_rg);

    div_data.appendChild(div_col_dt_emi_rg);
    div_col_dt_emi_rg.appendChild(div_floating_dt_emi_rg);
    div_floating_dt_emi_rg.appendChild(label_dt_emi_rg);
    div_floating_dt_emi_rg.appendChild(div_dt_emi_rg);

    
    row.appendChild(div_data);


    document.getElementById('dependentes').appendChild(row);

}

var myModalEl = document.getElementById('fichaCadastralModal');
myModalEl.addEventListener('hidden.bs.modal', function (event) {
        $('#estadocivil').html(null);
        $('#genero').html(null);
        $('#nacionalidade').html(null);
        $("#racaCor").html(null);
        $("#orgaoexp").html(null);
        $('#tipodeconta').html(null);
        $("#vinculo").html(null);
        $("#prefeitura").html(null);
        $('#nome').html(null);
        $('#nome_social').html(null);
        $('#matricula').html(null);
        $('#cpf').html(null);
        $('#pispasep').html(null);
        $('#dtnacimento').html(null);
        $('#ufnaruralidade').html(null);
        $('#naturalidade').html(null);
        $('#email').html(null);
        $('#nome_pai').html(null);
        $('#cpf_pai').html(null);
        $('#nome_mae').html(null);
        $('#cpf_mae').html(null);
        $('#rg').html(null);
        $('#ufexpedicao').html(null);
        $('#dtexpedicao').html(null);
        $('#num_reservista').html(null);
        $('#dtexpreservista').html(null);
        $('#serie_reservista').html(null);
        $('#ra_reservista').html(null);
        $('#num_teleitor').html(null);
        $('#zona_teleitor').html(null);
        $('#sessao_teleitor').html(null);
        $('#dtemissaoTitulo').html(null);
        $('#uf_teleitor').html(null);
        $('#ncnh').html(null);
        $('#catcnh').html(null);
        $('#validadecnh').html(null);
        $('#pcnh').html(null);
        $('#nctps').html(null);
        $('#serie_ctps').html(null);
        $('#uf_ctps').html(null);
        $('#dtemissaoctps').html(null);
        $('#codbanco').html(null);
        $('#banco').html(null);
        $('#agenciabanco').html(null);
        $('#digagenciabanco').html(null);
        $('#contabanco').html(null);
        $('#digcontabanco').html(null);
        $('#cep').html(null);
        $('#endereco').html(null);
        $('#numeroendereco').html(null);
        $('#quadra').html(null);
        $('#lote').html(null);
        $('#bairro').html(null);
        $('#ufendereco').html(null);
        $('#cidadeendereco').html(null);
        $('#tel_fixo').html(null);
        $('#tel_cel').html(null);
        $('#secretaria').html(null);
        $('#dtadmissao').html(null);
        $('#cargo').html(null);
        $('#salbase').html(null);
        $('#escola').html(null);
        $('#segatu').html(null);
        $('#dependentes').html(null);
})

</script>
</body>
</html>

